<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<!--
/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2003
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
************************************************************ {COPYRIGHT-END} ****/
-->
<%@taglib prefix="wcl" uri="WEB-INF/WCLTagLib.tld"%>
<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>

<%@page contentType="text/html;charset=UTF-8" 
		language="java"
		import="com.ibm.psw.reuse.gen.*,
                com.ibm.hwmca.ui.bonsai.*,
                com.ibm.hwmca.ui.bonsai.earth.*,
                com.ibm.hwmca.ui.bonsai.table.*,
                com.ibm.hwmca.ui.bonsai.servlet.*,
                com.ibm.hwmca.ui.bonsai.util.*,
                com.ibm.hwmca.fw.managed.*,
                com.ibm.hwmca.fw.ui.*,
                com.ibm.hwmca.fw.servlet.util.*,
                com.ibm.hwmca.fw.util.*,
                java.util.*,
                com.ibm.psw.wcl.core.markup.*,
                com.ibm.psw.wcl.core.cell.*,
                com.ibm.psw.wcl.core.renderer.RendererException,
				com.ibm.psw.wcl.core.renderer.RendererInfo,
                com.ibm.psw.wcl.components.table.*" %>

<META HTTP-EQUIV="Content-Type" CONTENT="text/html;CHARSET=UTF-8">

<%!
            String id = null;
%>
<HTML>
<HEAD>
<%  
	    ServletContext sc = session.getServletContext();		

        id = (String)session.getAttribute(BaseServlet.CURRENT_SELECTION);
        if (id != null)
        {
            HMCSession hmcSession = HMCSession.getHMCSession(session);
            if (hmcSession == null)
               throw new IllegalStateException("No HMC session!");

            BonsaiTreeNode selNode = BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(id);
            Set userRoles = User.getUser(hmcSession.getUserContext().getUserName()).getUserRoles();

            WTable table_ = new WTable(new TasksTableModel(selNode, userRoles),
                                       null,
                                       WTable.SORTFEATURE | WTable.FILTERFEATURE | WTable.GRIDLINEFEATURE | WTable.SHOWACTIONIMAGESFEATURE);
            table_.setSelectionMode(WTable.NO_SELECT);
            ///ICommandListener linkListener = new HyperLinkCommandListener();
            CustomTableCell cell = new CustomTableCell();
            try {
            table_.setColumnRenderer(0, CustomTableCellRenderer.class,cell,RendererInfo.HTML_ALL);
            }
            catch (RendererException re){
                re.printStackTrace();
            }

            session.setAttribute("tasksarea_table", table_);
        }
  %>

<!-- ===========================================================================
  This JSP is a view.  That is, the WclFacade and all data is defined inside a
  controller Servlet.
  ========================================================================== -->
<wcl:ControllerFoundation
	objectScope="session"
    wclFacadeScope="session"
    wclFacadeScopeId="caFacade1"
    pageName="tablepage1">

  <!-- =====================================================================
    Setup the NLS Resource Bundle to use in this JSP page
    ==================================================================== -->
  <wcl:ResourceBundle objectScopeId="JspResourceBundle"
                          className="com.ibm.hwmca.ui.bonsai.util.BonsaiResources"
  />

<!-- ===========================================================================
  Set the title of the browser from the Resource Bundle
  ========================================================================== -->
  <TITLE>
  <wcl:BundledResource objectScopeId="<%=BonsaiResources.JSP_HMC_TABLE_NAME%>"
               resourceBundleScopeId="JspResourceBundle"
                        defaultValue="ContentArea Table"
                            isInline="true"
  />
  </TITLE>
</HEAD>
<BODY>


  <!-- =====================================================================
    Set up the translatable resources for use in this jsp
    ==================================================================== -->        

    <!-- Sample Heading -->
    <wcl:BundledResource objectScopeId="<%=BonsaiResources.JSP_HMC_TABLE_NAME%>"
               resourceBundleScopeId="JspResourceBundle"
                        defaultValue="WSelectionBox Samples"
                            isInline="false" 
    />
  <%
   String title =   BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(id).getUIInfo().getName();
   String description = BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(id).getUIInfo().getCaption();
    %>
  <!-- =========================================================================
    Let's place a WTable into a WTitledLayout to display 
    ======================================================================== -->    
   <wcl:WTitledLayout
        objectScopeId="tableLayoutScope"
                   id="mainlayout"
                title="<%= title %>"
          description="<%= description %>"
   >

   <!-- =========================================================================
    Add the table
    ======================================================================== -->    
    <% if (session.getAttribute("tasksarea_table") != null) { %>
      <wcl:WTable 
           objectScopeId="tasksarea_table"
           id="wtable" 
      >
      </wcl:WTable>
      <% } else { %>no table<% } %>

      <BR>

    <BR>

    &nbsp;&nbsp;
 
    <BR>
  </wcl:WTitledLayout>
 </BODY>
</wcl:ControllerFoundation>
</HTML>

